% Funkce postupn odebr hrany a sleduje poet vzniklch komponent a velikost nejvt komponenty.
% VSTUPY:
% ukaz                    vektor. Vektor ukazatel, kter na pozici i udvaj,
%                         kde ve vektoru nasledovnk zanaj uzly sousedc s  
%                         uzlem i. 
% nasl                    vektor. Vektor nsledovnk.
% hrany                   vektor. Vektor oslovn hran.
% vzdal                   vektor. Vektor vzdlenost, pokud obsahuje
%                         nekoneno, znamen to, e tato hrana je
%                         neprjezdn.
% VSTUPY:
% N                       matice. Matice potu komponent grafu. Na i-t
%                         pozici udv poet komponent po zneprjezdnn i
%                         hran. Poet dk odpovd potu provedench
%                         nhodnch pokus.
% M                       matice. Matice velikost nejvt komponenty grafu. Na i-t
%                         pozici udv velikost nejvt komponenty po zneprjezdnn i
%                         hran. Poet dk odpovd potu provedench
%                         nhodnch pokus.
%meanN500                 vektor. Vektor obsahujc prmry sloupc maticeN
%meanM500                 vektor. Vektor obsahujc prmry sloupc maticeM

function [N,M,meanN500,meanM500]=vypocet_jistici_odchylka(ukaz,nasl,hrany,vzdal)
tic
N=zeros(500,length(hrany)/2); %matice obsahujc na dku postupn poet komponent pi odebrn (500 nhodnch pokus)
M=zeros(500,length(hrany)/2); %matice obsahujc na dku postupnou velikost nejvt komponenty pi odebrn (500 nhodnch pokus)
%provedeme 500 nhodnch pokus
for o=1:500
    o;
vzdal1=vzdal;
hrP=randperm(length(hrany)/2); %vygeneruje nhodnou permutaci vech hran, kter bude postupn zneprjezdovat
%zneprjezdnn hran, uren potu komponent a velikosti nejvt komponenty
for i=1:length(hrP)
vzdal1=zneprujezdneni_hrany(hrany,hrP(i),vzdal1); %zneprjezdn hranu a uprav vektor vzdlenost
[pocetkomp,velikost]=networkComponents_vzdal(ukaz,nasl,vzdal1); %vpoet potu komponent 
N(o,i)=pocetkomp;
M(o,i)=velikost(1);
end;
end;
meanN500=mean(N);
meanM500=mean(M);

%dle budeme pidvat dal nhodn pokusy, do t doby dokud budou vrazn mnit
%prmrn hodnoty
odchylka=0.01;
while odchylka>=0.001
    vzdal1=vzdal;
    hrP=randperm(length(hrany)/2); %dal permutace hran
    x=zeros(1,length(hrany)/2); %dal dek navc do matice N
    y=zeros(1,length(hrany)/2); %dal dek navc do matice M
    for i=1:length(hrP)
    vzdal1=zneprujezdneni_hrany(hrany,hrP(i),vzdal1); 
    [pocetkomp,velikost]=networkComponents_vzdal(ukaz,nasl,vzdal1);
    x(1,i)=pocetkomp;
    y(1,i)=velikost(1);
    end
    N=[N;x];
    meanN=mean(N);
    M=[M;y];
    meanM=mean(M);
    odchylka=max(abs(meanN500-meanN));
    meanN500=meanN;
    meanM500=meanM;
end;
toc
end